% ------------------------------------------------------------------------
% Script: infile_1d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 1D P-N model
% ------------------------------------------------------------------------

    % % System name
 
    system='1D P-N model';
 
    % % The absolute path to save the result files
 
    filepath=pwd;
 
    % % The dimension of P-N model: 1 or 2
 
    misdim=1;
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';
    
    % % The data of GSFE (unit: J/m2) and normalized disregistry vector (unit:1)
    
    Ux=[0
0.05199
0.08973
0.11731
0.15144
0.18918
0.25224
0.35237
0.45115
0.50291
0.55783
0.60394
0.70316
0.74634
0.80352
0.85166
0.87607
0.90139
0.94072
1.0022];
    SFE=[0.02158
0.80586
2.20869
3.6385
5.16081
6.50198
7.52712
6.3825
5.14924
4.98352
5.20513
5.68687
7.16678
7.50014
6.90086
5.2244
4.08748
2.81569
1.22786
0.02158];
    
    % % Which trial function of disregistry vector to employ (>=1)
    
    Nmis=12;
       
    % % Considering the first-order approximation in the trial function of disregistry
    %   vector (1) or NOT (0)
    
    mis_1st=0;
    
    % % The value of Burgers Vector (unit: A)
 
    BurVect=6.14;
    
    % % The values of shear modulus (unit: GPa) and Poisson's ratio (unit: 1)
 
    shear_modulus=278.6;
    poisson_ratio=0.0000;
    
    % % The dislocation type: edge ('e') or screw ('s')

    mistype='s';
    
    % % Which GSFE fitting function to employ (>=0)
    
    fitcut=6;
    
    % % Matrix of the lower and upper bounds, and initial values of each unknown 
    %   variable ([Lower bound, Upper bound, StartPoint]) 
    
    Xcoef_range=[  0.0000,  0.5000,  0.1667];
    Xdist_range=[-20.0000, 20.0000,  13.0000];
    Xwid_range =[  0.0000, 10.0000,  0.1000];
    Xalpha_range=[ 0.0000,  2.00000, 1.0000];
    
    % % The mothed for fitting the restoring force: "1d_fitting_toolbox" or "1d_lsq_curvefit"
    
    fitmethod='1d_lsq_curvefit';
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------
 
    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='TRUE';
 
    % % The method to calculate the Peierls stress: 1 or 2
    
    pnstrmethod=2;
 
    % % Interplanar distance ?x (unit: A) 

    Inpas=2.47;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field around dislocation core
% ------------------------------------------------------------------------
 
    % % Calculating the pressure field around dislocation core ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='FALSE';
    
    % % The lattice matrix for pressure field
    
    % pressfld_latxz=[];
    % pressfld_latyy=[];
